//
//  NSProcessInfo+MCAdditions.h
//  MCFoundation
//
//  Created by Alykhan Jetha on 18/10/06.
//  Copyright 1999-2006 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface NSProcessInfo (MCAdditions)

// generates a new UUID which is different that a globally unique string. Calls CoreFoundation to get the job done
+ (NSString *)newUUID;

// Wraps the -[NSHost hostName] call, timing how long it takes and logging out when it exceeds kNSProcessInfoHostNameLogThreshold
- (NSString*)mcTimedHostName;

// Returns the user id and group id of the currently logged in user (i.e. user running your program)
- (NSNumber*)mcConsoleUserID;
- (NSNumber*)mcConsoleGroupID;

// returns the pid's for the currently running named process for the user
+(NSArray *)mcProcessNumbersForUserProcessNamed:(NSString *)processName;

@end
